/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RollyOuchy
extends EntityLiving {
    public float newangle = 0.0f;

    public RollyOuchy(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 1.9f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Rolly Ouchy";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 9.0f;
        this.attackRange = 2.25f;
        this.movefrequency = 35;
        this.setExperience(29);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int bng = this.world.rand.nextInt(7);
        if (bng == 0) {
            return "OreSpawn:reel1";
        }
        if (bng == 1) {
            return "OreSpawn:reel2";
        }
        if (bng == 2) {
            return "OreSpawn:reel3";
        }
        if (bng == 3) {
            return "OreSpawn:reel4";
        }
        if (bng == 4) {
            return "OreSpawn:reel5";
        }
        if (bng == 5) {
            return "OreSpawn:reel6";
        }
        return "OreSpawn:reel7";
    }

    public String getHurtSound() {
        int bng = this.world.rand.nextInt(3);
        if (bng == 0) {
            return "OreSpawn:gurglehit1";
        }
        if (bng == 1) {
            return "OreSpawn:gurglehit2";
        }
        return "OreSpawn:gurglehit3";
    }

    public String getDeathSound() {
        int bng = this.world.rand.nextInt(3);
        if (bng == 0) {
            return "OreSpawn:drill1";
        }
        if (bng == 1) {
            return "OreSpawn:drill2";
        }
        return "OreSpawn:drill3";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.deadrollyouchy.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrollyouchy.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public float getNewangle() {
        this.newangle += (float)Math.sqrt(this.motionx * this.motionx + this.motiony * this.motiony + this.motionz * this.motionz) * 15.0f;
        while (this.newangle > 360.0f) {
            this.newangle -= 360.0f;
        }
        return (float)Math.toRadians(this.newangle);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof RollyOuchy) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RollyOuchytexture.png");
        }
        return this.texture;
    }
}

